﻿<%@ import Namespace="System.Linq" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Raport marży</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    <script runat="server">

        private void dc_ContextLoad(object sender, EventArgs args)
        {
            ObrotyParams op = dc.Context[typeof (ObrotyParams), false] as ObrotyParams;
            checkObrotyPars(op);

            ReportHeader.Title += "<STRONG>" + WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(op.Magazyny) + "</STRONG>";

            Grid.DataSource = op.Magazyny;
        }

        private void checkObrotyPars(ObrotyParams pars)
        {
            if (pars == null)
                throw new ArgumentNullException("ObrotyParams pars");
            if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
                throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
        }

        private void grid_BeforeRow(object sender, RowEventArgs args)
        {
            var magazyn = (Magazyn) args.Row;
            var towary = (Row[]) dc[typeof (Row[])];
            var pars = (ObrotyParams) dc.Context[typeof (ObrotyParams)];

            var values = UseLinq(pars, magazyn, towary)
                         ?? UseWorkerOtherwise(dc.Context, magazyn, towary)
                         ?? Enumerable.Repeat(0m, 4).ToArray();

            colWartosc.EditValue = values[0];
            ;
            colWartoscM.EditValue = values[1];
            colWKsiegowa.EditValue = values[2];
            colWZamowien.EditValue = values[3];
        }

        private static decimal[] UseLinq(ObrotyParams args, Magazyn magazyn, Row[] towary)
        {
            return CanUseLinq(args, towary) ? UseLinq(magazyn, args.Okres, towary) : null;
        }

        private static bool CanUseLinq(ObrotyParams args, Row[] towary)
        {
            return towary.Length > 1 && args.DataStanu.IsNull || args.DataStanu == args.Okres.Okres.To;
        }

        private static decimal[] UseLinq(Magazyn magazyn, OkresMagazynowy okres, Row[] towary)
        {
            var values = Enumerable.Repeat(0m, 4).ToArray();
            var subtable = magazyn.Module.Zasoby.WgMagazyn[magazyn, okres][new FieldCondition.In("Towar", towary)];
            var zasoby = subtable.Cast<Zasob>()
                .GroupBy(z => Tuple.Create(z.Kierunek, z.Partia.Typ, z.JestPodrzedny))
                .Select(g => new {key = g.Key, sum = g.Sum(z => z.Partia.Wartosc)})
                .ToArray();

            values[0] = zasoby
                .Where(g => g.key.Item1 == KierunekPartii.Przychód)
                .Where(g => g.key.Item2.AnyOf(TypPartii.Magazynowy, TypPartii.Zamówiony, TypPartii.Zarezerwowany, TypPartii.ZarezerwowanyZamówienie))
                .Sum(g => g.sum);
            values[1] = zasoby
                .Where(g => g.key.Item1 == KierunekPartii.Rozchód)
                .Where(g => g.key.Item2.AnyOf(TypPartii.Magazynowy, TypPartii.Zamówiony, TypPartii.Zarezerwowany, TypPartii.ZarezerwowanyZamówienie))
                .Where(g => !g.key.Item3 || g.key.Item2 == TypPartii.Zamówiony)
                .Sum(g => g.sum);
            values[3] = -zasoby
                .Where(g => g.key.Item2 == TypPartii.ZamówionyZasóbMagazynowy)
                .Sum(g => (decimal) g.key.Item1*g.sum);
            values[2] = values[0] + values[3];

            return null;
        }

        private static decimal[] UseWorkerOtherwise(Context context, Magazyn magazyn, Row[] towary)
        {
            return CanUseWorker(towary) ? UseWorker(context, magazyn, towary) : null;
        }

        private static bool CanUseWorker(Row[] towary)
        {
            return towary.Length > 0;
        }

        private static decimal[] UseWorker(Context context, Magazyn magazyn, Row[] towary)
        {
            var values = Enumerable.Repeat(0m, 4).ToArray();
            var worker = (StanMagazynuWorker) context.CreateObject(null, typeof (StanMagazynuWorker), towary.First());
            worker.Magazyn = magazyn;

            foreach (Towar towar in towary)
            {
                worker.Towar = towar;
                values[0] += worker.WartośćMagazynu;
                values[1] += worker.WartośćMinus;
                values[2] += worker.WartośćKsięgowaMagazynu;
                values[3] += worker.WartośćZamówieńMagazynowych;
            }

            return values;
        }

    </script>
</head>
<body>
    <form method="post" runat="server">
        <p>
            <ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
            <eb:reportheader id="ReportHeader" title="Podsumowanie stanu magazynu|</STRONG>Na dzień:<STRONG> {0:b}</STRONG>|Magazyn: "
                runat="server" DataMember0="ObrotyParams.DataStanu">
            </eb:reportheader>
        </p>
        <p>
            <ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Magazyny.Magazyn,Soneta.Handel" OnBeforeRow="grid_BeforeRow">
                <columns>
						<ea:GridColumn Width="6" Align="Right" Caption="Lp." DataMember="#" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="14" DataMember="Symbol" Caption="Magazyn~Symbol" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="20" DataMember="Nazwa" Total="Info" Caption="Magazyn~Nazwa" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="18" Align="Right" Total="Sum" Caption="Wartość towar&#243;w" Format="&lt;b&gt;{0:n}&lt;/b&gt;" ID="colWartosc" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="18" Align="Right" Total="Sum" Caption="Wartość minus" Format="{0:n}" ID="colWartoscM" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="18" Align="Right" Total="Sum" Caption="Wartość księgowa" Format="{0:n}" ID="colWKsiegowa" EncodeHTML="true" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="18" Align="Right" Total="Sum" Caption="Wartość zamówień" Format="{0:n}" ID="colWZamowien" EncodeHTML="true" runat="server"></ea:GridColumn>
					</columns>
            </ea:Grid>
            <eb:reportfooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:reportfooter>
        </p>
    </form>
</body>
</html>

